#include <bits/stdc++.h>
using namespace std;

const long long INF = (long long)4e18;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N;
    long long W;
    double eps;
    cin >> N >> W >> eps;

    vector<long long> w(N), v(N);
    for (int i = 0; i < N; i++)
    {
        cin >> w[i] >> v[i];
    }

    long long Vmax = 0;
    for (int i = 0; i < N; i++)
        Vmax = max(Vmax, v[i]);

    double K = eps * (double)Vmax / N;
    if (K < 1e-12) K = 1e-12;

    vector<int> vs(N);
    int sumV = 0;
    for (int i = 0; i < N; i++)
    {
        vs[i] = (int)(v[i] / K);
        sumV += vs[i];
    }

    vector<long long> dp(sumV + 1, INF);
    vector<vector<char>> uzeti(N, vector<char>(sumV + 1, 0));

    dp[0] = 0;

    // 4. DP
    for (int i = 0; i < N; i++)
    {
        for (int s = sumV; s >= vs[i]; s--)
        {
            if (dp[s - vs[i]] + w[i] < dp[s])
            {
                dp[s] = dp[s - vs[i]] + w[i];
                uzeti[i][s] = 1;
            }
        }
    }
int bestS = 0;
    for (int s = 0; s <= sumV; s++)
    {
        if (dp[s] <= W)
            bestS = s;
    }

    vector<int> izabran;
    int s = bestS;
    for (int i = N - 1; i >= 0; i--)
    {
        if (s >= vs[i] && uzeti[i][s])
        {
            izabran.push_back(i + 1);
            s -= vs[i];
        }
    }

    reverse(izabran.begin(), izabran.end());
    cout << izabran.size() << "\n";
    for (int i = 0; i < izabran.size(); i++)
        cout << izabran[i] << " ";

    return 0;
}